------------------------------------------------------------------------------
--	FILE:	 CordiformEarth.Lua
--  Convertion of Civ V smellymummy's Standart Cordiform Earth
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 80
local g_iH = 52
local g_iFlags = {}
local g_continentsFrac = nil

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end


-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	-- Everything has been moved to the modded AssignStartingPlots in the "override" folder, search for "YnAMP" string in that file
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)

end

function GetNaturalWonders()
	local NaturalWonders = {}
	
	NaturalWonders[GameInfo.Features["FEATURE_BARRIER_REEF"].Index] 	 = { X = 76, Y = 14}		-- 2 plots, coast, 1st plot is SOUTHEAST	
	--NaturalWonders[GameInfo.Features["FEATURE_CLIFFS_DOVER"].Index] 	 = { X = 32, Y = 32}    	-- 2 plots, hills on coast, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_CRATER_LAKE"].Index] 		 = { X = 15, Y = 42}   	
	--NaturalWonders[GameInfo.Features["FEATURE_DEAD_SEA"].Index] 		 = { X = 47, Y = 19}    	-- 2 plots, flat desert surrounded by desert, 1st plot is SOUTHWEST	
	NaturalWonders[GameInfo.Features["FEATURE_EVEREST"].Index] 			 = { X = 57, Y = 25}    	-- 3 plots, mountains, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_GALAPAGOS"].Index] 		 = { X = 8, Y = 15}   		-- 2 plots, coast, surrounded by coast, 1st plot is SOUTHWEST
	NaturalWonders[GameInfo.Features["FEATURE_KILIMANJARO"].Index] 		 = { X = 43, Y = 9}    	
	NaturalWonders[GameInfo.Features["FEATURE_PANTANAL"].Index] 		 = { X = 16, Y = 13}   		-- 4 plots, flat grass/plains without features, 1st plot is SOUTH-WEST	
	--NaturalWonders[GameInfo.Features["FEATURE_PIOPIOTAHI"].Index] 		 = { X = 79, Y = 8}    	-- 3 plots, flat grass near coast, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_TORRES_DEL_PAINE"].Index]  = { X = 16, Y = 5}    	-- 2 plots EAST-WEST without features, 1st plot is WEST	
	NaturalWonders[GameInfo.Features["FEATURE_TSINGY"].Index] 			 = { X = 45, Y = 7}    	
	--NaturalWonders[GameInfo.Features["FEATURE_YOSEMITE"].Index] 		 = { X = 12, Y = 41}   	-- 2 plots EAST-WEST, flat tundra/plains without features, 1st plot is WEST
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	-- Civ6 Data on top of Civ5 Data to add cliffs on a civ5 map (copy from Lua.log below and on each lines remove everything before "Civ6DataToConvert")
	-- See AssignStartingPlots.lua in Yet (Not) Another Maps Pack for the export code
 	-- Civ6DataToConvert[x][y]={{IsNEOfCliff,IsWOfCliff,IsNWOfCliff},}
	-- Deprecated, should use directly Civ6 Map Data instead
	return {}
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data (from Civ6 WB)
	-- MapToConvert[x][y] = {civ6TerrainType, civ6FeatureTypes, civ6ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ6ResourceType, num}, {IsNEOfCliff, IsWOfCliff, IsNWOfCliff} }

	-- Map Data (from Civ5)
	-- MapToConvert[x][y] = {civ5TerrainType, civ5PlotTypes, civ5FeatureTypes, civ5ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ5ResourceType, num} }

	
 MapToConvert[0][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[19][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][1]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[17][2]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][2]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[22][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[24][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][2]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[39][2]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][2]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[41][2]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][2]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][3]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[18][3]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][3]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][3]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[25][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[36][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][3]={1,2,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][3]={0,1,5,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[40][3]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][3]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[6][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][4]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][4]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][4]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[20][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][4]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[23][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][4]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[38][4]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][4]={1,2,5,3,{{0,-1},{1,3},{0,-1}},{21,1}}
 MapToConvert[40][4]={0,1,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][4]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[42][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][4]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[46][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][4]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][4]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][4]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][4]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[61][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][4]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[63][4]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[66][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[68][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][4]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][4]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[76][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][5]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[4][5]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][5]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[17][5]={1,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][5]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[21][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[24][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[35][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][5]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][5]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][5]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][5]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][5]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][5]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[43][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][5]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][5]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[47][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[49][5]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][5]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[58][5]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][5]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][5]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[64][5]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][5]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][5]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[74][5]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][5]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[77][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][6]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][6]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][6]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][6]={1,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[37][6]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][6]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[39][6]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][6]={0,2,5,3,{{0,-1},{0,-1},{1,1}},{21,1}}
 MapToConvert[41][6]={0,2,-1,3,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[42][6]={1,2,1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][6]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[46][6]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[63][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][6]={1,2,-1,2,{{0,-1},{0,-1},{1,4}},{31,1}}
 MapToConvert[69][6]={1,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][6]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[71][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][7]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[4][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[8][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][7]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[16][7]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][7]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[18][7]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][7]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[37][7]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][7]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{21,1}}
 MapToConvert[40][7]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{21,1}}
 MapToConvert[41][7]={1,2,1,3,{{0,-1},{1,3},{1,4}},{21,1}}
 MapToConvert[42][7]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][7]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[44][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][7]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][7]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[47][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[67][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][7]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][7]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][7]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][7]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[75][7]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][8]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][8]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[10][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][8]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][8]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][8]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[32][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][8]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[38][8]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][8]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][8]={1,1,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][8]={1,2,1,3,{{0,-1},{1,3},{0,-1}},{21,1}}
 MapToConvert[42][8]={1,1,1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][8]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][8]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][8]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[49][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][8]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][8]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[70][8]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][8]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][8]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[73][8]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][8]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][8]={0,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[76][8]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[77][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[4][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][9]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[15][9]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][9]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][9]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{25,1}}
 MapToConvert[18][9]={0,2,-1,1,{{1,2},{0,-1},{1,1}},{25,1}}
 MapToConvert[19][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[22][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][9]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][9]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][9]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[39][9]={1,2,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[40][9]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[41][9]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][9]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[43][9]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[48][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][9]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[67][9]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][9]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][9]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][9]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[71][9]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][9]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][9]={0,2,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[74][9]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][9]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[4][10]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[5][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][10]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][10]={1,2,15,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[17][10]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[18][10]={1,2,1,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][10]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][10]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[21][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][10]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{21,1}}
 MapToConvert[37][10]={1,2,1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[38][10]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][10]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][10]={1,2,1,3,{{0,-1},{1,0},{1,1}},{21,1}}
 MapToConvert[41][10]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[42][10]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][10]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[45][10]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][10]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][10]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][10]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[69][10]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][10]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][10]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][10]={1,2,21,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][10]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][10]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{30,1}}
 MapToConvert[75][10]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][11]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[14][11]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][11]={1,0,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[16][11]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][11]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[18][11]={1,2,1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][11]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[22][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[31][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[34][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][11]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][11]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{22,1}}
 MapToConvert[38][11]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][11]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][11]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][11]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][11]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][11]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][11]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][11]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[47][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][11]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][11]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[70][11]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[71][11]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][11]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[73][11]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][11]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][11]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][11]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[77][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][12]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][12]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][12]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[17][12]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][12]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[19][12]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][12]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][12]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[30][12]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][12]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][12]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[37][12]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[40][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[42][12]={0,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[43][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[44][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][12]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[46][12]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][12]={1,2,1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[71][12]={0,2,2,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[72][12]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][12]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][12]={1,2,1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[75][12]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[76][12]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][12]={5,3,10,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[79][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[12][13]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[13][13]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][13]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][13]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[16][13]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][13]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[18][13]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][13]={1,1,1,1,{{0,-1},{1,0},{1,1}},{17,1}}
 MapToConvert[20][13]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[28][13]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][13]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[30][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[32][13]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][13]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[34][13]={1,1,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[35][13]={2,1,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[36][13]={2,2,4,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[37][13]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{24,1}}
 MapToConvert[38][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][13]={1,1,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][13]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[44][13]={2,1,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[45][13]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][13]={2,1,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[47][13]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[48][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[50][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[60][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[70][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[71][13]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][13]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][13]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[74][13]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][13]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][14]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][14]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][14]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][14]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][14]={1,2,1,1,{{0,-1},{1,0},{1,1}},{22,1}}
 MapToConvert[17][14]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[18][14]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[19][14]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][14]={1,2,1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[21][14]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][14]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[23][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][14]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][14]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[32][14]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[33][14]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[34][14]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[35][14]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[37][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[40][14]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[42][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[44][14]={2,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[45][14]={2,2,4,3,{{1,5},{1,0},{0,-1}},{24,1}}
 MapToConvert[46][14]={2,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][14]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[52][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[54][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][14]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[59][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][14]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[73][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][14]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][14]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[78][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[10][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][15]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[12][15]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][15]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][15]={1,2,1,1,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[15][15]={1,2,1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[16][15]={1,1,1,1,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[17][15]={1,2,1,1,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[18][15]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][15]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[20][15]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][15]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[22][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[28][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[30][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[32][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[34][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[36][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][15]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[39][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[40][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][15]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[44][15]={2,2,4,3,{{1,5},{1,0},{0,-1}},{24,1}}
 MapToConvert[45][15]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[47][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][15]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[50][15]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][15]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[55][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][15]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[60][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][15]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[75][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][15]={5,3,10,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][16]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[10][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][16]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][16]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][16]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][16]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{33,1}}
 MapToConvert[15][16]={1,1,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[16][16]={1,1,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[17][16]={1,2,1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][16]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{24,1}}
 MapToConvert[19][16]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][16]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][16]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[38][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][16]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[43][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[44][16]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[45][16]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][16]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][16]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][16]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[54][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[58][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][16]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][16]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[66][16]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[78][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][17]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[11][17]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][17]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][17]={1,2,1,1,{{0,-1},{0,-1},{1,1}},{33,1}}
 MapToConvert[14][17]={1,2,1,1,{{1,2},{1,0},{0,-1}},{-1,0}}
 MapToConvert[15][17]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][17]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[17][17]={0,2,2,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[18][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[21][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[22][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[29][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][17]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[31][17]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][17]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[35][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[37][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[38][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[40][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][17]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[44][17]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[46][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][17]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][17]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[49][17]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[50][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[52][17]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][17]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[55][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][17]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][17]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[60][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][17]={1,2,18,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][17]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][17]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][17]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][17]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][18]={0,2,5,1,{{0,-1},{1,0},{0,-1}},{20,1}}
 MapToConvert[13][18]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][18]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[15][18]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{24,1}}
 MapToConvert[16][18]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[20][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][18]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[34][18]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[38][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[42][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[43][18]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[44][18]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[46][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][18]={1,2,19,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][18]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][18]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[51][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][18]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][18]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[54][18]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][18]={1,1,1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][18]={0,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[60][18]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][18]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{30,1}}
 MapToConvert[67][18]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][18]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[70][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][19]={0,2,5,1,{{0,-1},{1,0},{0,-1}},{20,1}}
 MapToConvert[12][19]={0,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][19]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][19]={0,2,2,1,{{0,-1},{0,-1},{1,1}},{24,1}}
 MapToConvert[15][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[18][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[27][19]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][19]={1,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][19]={1,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][19]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[36][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[39][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[43][19]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[44][19]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][19]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][19]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[51][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[56][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[58][19]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][19]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{31,1}}
 MapToConvert[60][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][19]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[64][19]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][19]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][19]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[68][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][19]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][19]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][19]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[72][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[10][20]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][20]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[13][20]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[14][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[30][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][20]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{2,6}}
 MapToConvert[32][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[35][20]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[36][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[41][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][20]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[48][20]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][20]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[50][20]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][20]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[55][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][20]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][20]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][20]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[62][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][20]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][20]={1,1,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[65][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[67][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][20]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[71][20]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][20]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][20]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[75][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][21]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][21]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][21]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[15][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][21]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[37][21]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][21]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[42][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][21]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][21]={2,2,4,2,{{1,2},{1,0},{1,1}},{24,1}}
 MapToConvert[49][21]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{24,1}}
 MapToConvert[50][21]={2,2,4,2,{{1,2},{1,3},{1,1}},{24,1}}
 MapToConvert[51][21]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[53][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][21]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][21]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[56][21]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][21]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][21]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[60][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][21]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][21]={1,0,11,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][21]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[73][21]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][22]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][22]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[13][22]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[29][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][22]={0,1,12,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][22]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][22]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[34][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][22]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[39][22]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][22]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][22]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][22]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[45][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[47][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[48][22]={1,1,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[49][22]={2,2,4,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][22]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{24,1}}
 MapToConvert[51][22]={2,2,4,2,{{0,-1},{1,3},{1,4}},{24,1}}
 MapToConvert[52][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][22]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][22]={1,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[55][22]={1,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][22]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{27,1}}
 MapToConvert[57][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[58][22]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[64][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][22]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[66][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][22]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[68][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][22]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][22]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[75][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][23]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[6][23]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[16][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[28][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][23]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[30][23]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][23]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][23]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][23]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][23]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{17,1}}
 MapToConvert[37][23]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][23]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][23]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[41][23]={1,1,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[42][23]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][23]={1,1,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[48][23]={1,2,-1,2,{{1,2},{1,3},{0,-1}},{27,1}}
 MapToConvert[49][23]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][23]={2,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[51][23]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][23]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[53][23]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][23]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[55][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][23]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][23]={1,1,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[58][23]={0,2,-1,2,{{1,2},{1,0},{1,1}},{34,1}}
 MapToConvert[59][23]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[61][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][23]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][23]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][23]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][23]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][23]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][23]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[70][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[72][23]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[76][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[5][24]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][24]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][24]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[8][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][24]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][24]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][24]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[29][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][24]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[31][24]={1,2,5,4,{{1,5},{0,-1},{1,4}},{20,1}}
 MapToConvert[32][24]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[33][24]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[34][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][24]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[38][24]={0,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][24]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][24]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][24]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][24]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[45][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][24]={0,1,-1,2,{{0,-1},{1,0},{0,-1}},{17,1}}
 MapToConvert[47][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][24]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][24]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[50][24]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][24]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][24]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][24]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][24]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][24]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][24]={2,0,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][24]={1,1,1,2,{{1,2},{0,-1},{1,1}},{17,1}}
 MapToConvert[58][24]={1,0,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][24]={0,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][24]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][24]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{2,6}}
 MapToConvert[66][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[68][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[75][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][25]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[6][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[9][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][25]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][25]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][25]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][25]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][25]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][25]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][25]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][25]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[38][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][25]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][25]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[41][25]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][25]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][25]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][25]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][25]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[48][25]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][25]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][25]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[51][25]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][25]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][25]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][25]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[56][25]={1,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][25]={1,1,1,2,{{1,2},{0,-1},{1,1}},{35,1}}
 MapToConvert[58][25]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][25]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][25]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{1,2}}
 MapToConvert[61][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][25]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][25]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{22,1}}
 MapToConvert[64][25]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][25]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[70][25]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[73][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][25]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[4][26]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[5][26]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][26]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][26]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[8][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][26]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][26]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[11][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][26]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[13][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[14][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[16][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[31][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][26]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[34][26]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][26]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[36][26]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[37][26]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[38][26]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][26]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][26]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][26]={0,0,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[42][26]={0,1,5,4,{{1,2},{0,-1},{1,1}},{9,1}}
 MapToConvert[43][26]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[44][26]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][26]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[50][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[53][26]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][26]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[55][26]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][26]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[58][26]={1,2,20,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][26]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][26]={1,2,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][26]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][26]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{21,1}}
 MapToConvert[63][26]={1,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[64][26]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[66][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][26]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[69][26]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][26]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[72][26]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[75][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][26]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][27]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][27]={1,2,5,1,{{0,-1},{1,0},{1,1}},{20,1}}
 MapToConvert[5][27]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[9][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][27]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[32][27]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][27]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[34][27]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][27]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][27]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][27]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][27]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[39][27]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][27]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[41][27]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][27]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][27]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[44][27]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][27]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[48][27]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[51][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][27]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][27]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][27]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[59][27]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][27]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][27]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{21,1}}
 MapToConvert[62][27]={1,2,1,2,{{1,2},{0,-1},{0,-1}},{21,1}}
 MapToConvert[63][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[65][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][27]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][27]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][27]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][28]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][28]={0,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[6][28]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{25,1}}
 MapToConvert[7][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][28]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[16][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[30][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][28]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[33][28]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{25,1}}
 MapToConvert[34][28]={0,2,-1,4,{{1,5},{1,0},{0,-1}},{25,1}}
 MapToConvert[35][28]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[36][28]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[37][28]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][28]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][28]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][28]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[41][28]={0,0,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][28]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[43][28]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][28]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][28]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][28]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][28]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][28]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[55][28]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][28]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[57][28]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][28]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][28]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][28]={1,2,1,2,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[61][28]={1,1,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[62][28]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[64][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[67][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[3][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][29]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][29]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][29]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[11][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][29]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[18][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][29]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][29]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[32][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][29]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{25,1}}
 MapToConvert[34][29]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][29]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[36][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][29]={0,1,5,4,{{1,2},{1,0},{1,1}},{9,1}}
 MapToConvert[38][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][29]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{17,1}}
 MapToConvert[40][29]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][29]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][29]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][29]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[45][29]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[46][29]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[47][29]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][29]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[49][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][29]={2,2,4,2,{{0,-1},{0,-1},{1,4}},{24,1}}
 MapToConvert[52][29]={2,2,4,2,{{1,5},{0,-1},{1,4}},{24,1}}
 MapToConvert[53][29]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[54][29]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][29]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][29]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][29]={1,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][29]={1,2,1,2,{{1,2},{1,0},{1,1}},{21,1}}
 MapToConvert[59][29]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][29]={1,2,1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[63][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[64][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[69][29]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][29]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[72][29]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[75][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][29]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][30]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[5][30]={1,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[6][30]={1,2,5,1,{{1,2},{0,-1},{0,-1}},{20,1}}
 MapToConvert[7][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][30]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][30]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[15][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][30]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[30][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][30]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[34][30]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][30]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][30]={0,1,5,4,{{0,-1},{1,0},{1,1}},{9,1}}
 MapToConvert[37][30]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][30]={1,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][30]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][30]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][30]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[42][30]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[44][30]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][30]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][30]={1,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[47][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[48][30]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[49][30]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{26,1}}
 MapToConvert[50][30]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][30]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{35,1}}
 MapToConvert[52][30]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][30]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][30]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][30]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][30]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][30]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][30]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][30]={1,1,1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][30]={0,1,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[61][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[63][30]={0,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[64][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][30]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[66][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[68][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][30]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{30,1}}
 MapToConvert[73][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[3][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][31]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][31]={1,1,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[6][31]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][31]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[8][31]={0,2,2,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[9][31]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[10][31]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][31]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[12][31]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[13][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[19][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[31][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][31]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[35][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][31]={0,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[37][31]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[38][31]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][31]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[40][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][31]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][31]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{31,1}}
 MapToConvert[46][31]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][31]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][31]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[49][31]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][31]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[51][31]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][31]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[53][31]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][31]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][31]={2,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[56][31]={2,1,-1,2,{{1,2},{1,0},{1,1}},{16,1}}
 MapToConvert[57][31]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[58][31]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][31]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][31]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{26,1}}
 MapToConvert[61][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][31]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[63][31]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][31]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][31]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[71][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][31]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][32]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[6][32]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[7][32]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][32]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][32]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[10][32]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][32]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][32]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[13][32]={0,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[14][32]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[15][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[18][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[23][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[28][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[29][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][32]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][32]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[33][32]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][32]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{1,2}}
 MapToConvert[37][32]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][32]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[39][32]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][32]={1,2,-1,4,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[41][32]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][32]={1,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[43][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[44][32]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[45][32]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[46][32]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][32]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[49][32]={2,2,4,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[50][32]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][32]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][32]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][32]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][32]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][32]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[56][32]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][32]={2,2,4,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][32]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][32]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[60][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][32]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[62][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[63][32]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[64][32]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{26,1}}
 MapToConvert[65][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[70][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][32]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[73][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][32]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[4][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][33]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][33]={1,0,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[7][33]={2,2,3,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][33]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][33]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[10][33]={0,1,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[11][33]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][33]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][33]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{34,1}}
 MapToConvert[14][33]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][33]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][33]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[21][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][33]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][33]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][33]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][33]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][33]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{30,1}}
 MapToConvert[39][33]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][33]={1,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][33]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{26,1}}
 MapToConvert[42][33]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][33]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[45][33]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{31,1}}
 MapToConvert[46][33]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][33]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][33]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[49][33]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][33]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][33]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][33]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[53][33]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][33]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][33]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][33]={2,2,4,2,{{0,-1},{1,0},{1,1}},{24,1}}
 MapToConvert[57][33]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[58][33]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][33]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][33]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{26,1}}
 MapToConvert[61][33]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][33]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][33]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[66][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[68][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][33]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[71][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][34]={2,1,-1,1,{{0,-1},{0,-1},{1,4}},{39,1}}
 MapToConvert[8][34]={2,1,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[9][34]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[10][34]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[11][34]={0,2,-1,1,{{1,2},{0,-1},{1,4}},{30,1}}
 MapToConvert[12][34]={0,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[13][34]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][34]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][34]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][34]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[17][34]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][34]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[19][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][34]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][34]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[22][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[29][34]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[30][34]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][34]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[33][34]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[34][34]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{1,4}}
 MapToConvert[35][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][34]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][34]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][34]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{26,1}}
 MapToConvert[41][34]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[42][34]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][34]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[45][34]={0,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[46][34]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][34]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[48][34]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][34]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[50][34]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[51][34]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][34]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][34]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][34]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[56][34]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][34]={2,2,4,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[58][34]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[59][34]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{1,4}}
 MapToConvert[60][34]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[61][34]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{26,1}}
 MapToConvert[62][34]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[63][34]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][34]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[65][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][34]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{1,2}}
 MapToConvert[70][34]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[73][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][35]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[5][35]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][35]={2,2,4,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[7][35]={2,2,4,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[8][35]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][35]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][35]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[11][35]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][35]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{2,6}}
 MapToConvert[13][35]={0,2,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][35]={0,2,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[15][35]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][35]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][35]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][35]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[23][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][35]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][35]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{1,4}}
 MapToConvert[30][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][35]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][35]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[38][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][35]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][35]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[43][35]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][35]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][35]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][35]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][35]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][35]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{2,6}}
 MapToConvert[49][35]={1,2,-1,2,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[50][35]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][35]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][35]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][35]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[54][35]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][35]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][35]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[57][35]={1,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][35]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][35]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][35]={0,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[61][35]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][35]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{30,1}}
 MapToConvert[63][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][35]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][35]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][35]={1,2,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][36]={2,2,4,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][36]={2,1,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[9][36]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[10][36]={1,2,9,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][36]={1,2,-1,1,{{0,-1},{0,-1},{1,4}},{27,1}}
 MapToConvert[12][36]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][36]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[14][36]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][36]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[16][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][36]={0,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[18][36]={0,2,5,1,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[19][36]={0,1,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][36]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][36]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][36]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][36]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[34][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][36]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[42][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][36]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[45][36]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][36]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{30,1}}
 MapToConvert[47][36]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{30,1}}
 MapToConvert[48][36]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][36]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][36]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{27,1}}
 MapToConvert[51][36]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][36]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][36]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][36]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][36]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[56][36]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][36]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][36]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][36]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][36]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{30,1}}
 MapToConvert[61][36]={0,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][36]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[63][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[66][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][37]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[7][37]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][37]={2,2,4,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[9][37]={2,2,3,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][37]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][37]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][37]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[13][37]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[14][37]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][37]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[17][37]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][37]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][37]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][37]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[21][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][37]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[33][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[39][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][37]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][37]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][37]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{23,1}}
 MapToConvert[45][37]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[46][37]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][37]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][37]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[49][37]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][37]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][37]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][37]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[53][37]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][37]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][37]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][37]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][37]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{34,1}}
 MapToConvert[58][37]={0,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][37]={0,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][37]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][37]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][37]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[70][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][38]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][38]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[10][38]={1,2,7,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][38]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[12][38]={1,1,13,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][38]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[14][38]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][38]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][38]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][38]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][38]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[19][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][38]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[24][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][38]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][38]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[38][38]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][38]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[44][38]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][38]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[47][38]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][38]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][38]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][38]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][38]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[52][38]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][38]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][38]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][38]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[56][38]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][38]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][38]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[61][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][38]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[67][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[69][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][39]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][39]={0,1,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[11][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][39]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][39]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[15][39]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{33,1}}
 MapToConvert[16][39]={0,2,5,1,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[17][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][39]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][39]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[22][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[26][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][39]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][39]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][39]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[40][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][39]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[42][39]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[45][39]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][39]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][39]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][39]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[49][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][39]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[54][39]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][39]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[57][39]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[58][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[62][39]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][39]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][40]={0,2,-1,1,{{0,-1},{1,0},{1,1}},{1,4}}
 MapToConvert[12][40]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][40]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[14][40]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][40]={0,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[16][40]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{33,1}}
 MapToConvert[17][40]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[18][40]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][40]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][40]={3,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[33][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[34][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[37][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][40]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][40]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][40]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][40]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][40]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[44][40]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][40]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][40]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{17,1}}
 MapToConvert[47][40]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][40]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][40]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][40]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][40]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[52][40]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][40]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][40]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][40]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[56][40]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[59][40]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][40]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][40]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][40]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][40]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[65][40]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][40]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][40]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[75][40]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][40]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[77][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][41]={0,2,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[12][41]={0,1,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[13][41]={0,1,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[14][41]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[15][41]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][41]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][41]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[18][41]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][41]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][41]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[21][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][41]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[23][41]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][41]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[25][41]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[27][41]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][41]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][41]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[32][41]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][41]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[40][41]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][41]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][41]={3,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[44][41]={3,1,5,4,{{1,5},{0,-1},{1,4}},{9,1}}
 MapToConvert[45][41]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][41]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][41]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{2,6}}
 MapToConvert[48][41]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[49][41]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{27,1}}
 MapToConvert[50][41]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][41]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][41]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[54][41]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][41]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][41]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[57][41]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][41]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][41]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[60][41]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][41]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][41]={6,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][42]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[13][42]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][42]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][42]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][42]={0,1,5,1,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[17][42]={0,1,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[18][42]={0,2,5,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[19][42]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][42]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][42]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[22][42]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][42]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][42]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][42]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][42]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][42]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[35][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[36][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[39][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][42]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[45][42]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][42]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[47][42]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[48][42]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][42]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][42]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][42]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[53][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[59][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][42]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[67][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][43]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][43]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[14][43]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][43]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][43]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][43]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][43]={0,2,5,1,{{0,-1},{0,-1},{1,1}},{23,1}}
 MapToConvert[19][43]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[20][43]={3,2,-1,1,{{1,2},{0,-1},{1,1}},{31,1}}
 MapToConvert[21][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][43]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][43]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][43]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[26][43]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][43]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][43]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][43]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][43]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][43]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][43]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[41][43]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][43]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[43][43]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][43]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][43]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[46][43]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[47][43]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[49][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][43]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[51][43]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][43]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][43]={0,1,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[54][43]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[55][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][43]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[57][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][43]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[61][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][43]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][43]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[64][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][43]={6,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][44]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[7][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[17][44]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][44]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][44]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][44]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][44]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][44]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[23][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][44]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][44]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[28][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][44]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][44]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][44]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][44]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][44]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][44]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][44]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][44]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[45][44]={3,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[46][44]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[47][44]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[48][44]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][44]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][44]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][44]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][44]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][44]={0,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[55][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[56][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,6}}
 MapToConvert[60][44]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[61][44]={0,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][44]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[63][44]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][45]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[15][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][45]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][45]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[18][45]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][45]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][45]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[21][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][45]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][45]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[24][45]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][45]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][45]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][45]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][45]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][45]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][45]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][45]={4,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[44][45]={4,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][45]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{31,1}}
 MapToConvert[46][45]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][45]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][45]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[49][45]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][45]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[52][45]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][45]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{2,6}}
 MapToConvert[54][45]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][45]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[56][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][45]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][45]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][45]={0,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][46]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[6][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][46]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[20][46]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][46]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][46]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[23][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][46]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][46]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][46]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][46]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][46]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][46]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[45][46]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[46][46]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][46]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[48][46]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][46]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][46]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][46]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][46]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][46]={0,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[54][46]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[58][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][46]={1,0,8,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[61][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][47]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[20][47]={3,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[21][47]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][47]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][47]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][47]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[25][47]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][47]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][47]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][47]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][47]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][47]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[35][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][47]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[41][47]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][47]={4,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[43][47]={3,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[44][47]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[45][47]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[46][47]={3,1,5,2,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[47][47]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][47]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][47]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[51][47]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][47]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[55][47]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[57][47]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[59][47]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[63][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[76][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][48]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{39,1}}
 MapToConvert[6][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][48]={3,1,5,1,{{0,-1},{0,-1},{1,1}},{9,1}}
 MapToConvert[22][48]={3,1,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[23][48]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[24][48]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][48]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][48]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][48]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][48]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][48]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][48]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][48]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][48]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][48]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][48]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][48]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][48]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{0,6}}
 MapToConvert[38][48]={3,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][48]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[40][48]={3,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][48]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][48]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][48]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[44][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][48]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][48]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][48]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][48]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[62][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][49]={3,2,5,1,{{0,-1},{0,-1},{1,1}},{20,1}}
 MapToConvert[23][49]={3,2,5,1,{{1,2},{1,0},{1,1}},{20,1}}
 MapToConvert[24][49]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][49]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[26][49]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][49]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[28][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][49]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][49]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][49]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[35][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][49]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][49]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][49]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[39][49]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][49]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][49]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][49]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][49]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][49]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[46][49]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[48][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][49]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[52][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[54][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][49]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[58][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][50]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][50]={6,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][50]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[42][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[45][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
	
	return MapToConvert
end